#include "struktury.h"                                                          //komplexnější proměnné a objekty

geo::geo() : xArray(nullptr), vArray(nullptr), count(0) {}                      //konstruktor

geo::~geo() {                                                                   //destruktor
    delete[] xArray;
    delete[] vArray;
}

void geo::insert(const f_vec& xData, const f_vec& vData) {                      //vložení nového prvku
    if (count >= kapacita) {                                                    //jestli je dostatečná kapacita pro nový prvek
        int novaKapacita = kapacita + 256;                                      //zvětšíme kapacitu o konstantní velikost
        f_vec* newXArray = new f_vec[novaKapacita];
        f_vec* newVArray = new f_vec[novaKapacita];
        for (int i = 0; i < count; ++i) {                                       //zkopírujeme prvky ze starých polí do nových
            newXArray[i] = xArray[i];
            newVArray[i] = vArray[i];
        }
        delete[] xArray;                                                        //uvolníme stará pole
        delete[] vArray;
        xArray = newXArray;                                                     //aktualizujeme ukazatele a kapacitu
        vArray = newVArray;
        kapacita = novaKapacita;
    }
    xArray[count] = xData;                                                      //přidáme nové prvky
    vArray[count] = vData;
    ++count;
}

f_vec geo::getX(int index) const {                                              //vrácení polohy
    return xArray[index];
}

f_vec geo::getV(int index) const {                                              //vrácení rychlosti
    return vArray[index];
}

int geo::getCount() const {                                                     //vrácení délky geodetiky
    return count;
}

Counter::Counter() {                                                            //konstruktor
    n = 0;
}

void Counter::increment() {                                                     //inkrementace počítadla
    mutex.lock();
    ++n;
    mutex.unlock();
}

void Counter::decrement() {                                                     //dekrementace počítadla
    mutex.lock();
    --n;
    mutex.unlock();
}

int Counter::value() const {                                                    //vrácení hodnoty počítadla
    QMutexLocker locker(&mutex);
    return n;
}

MyImage::MyImage(int width, int height) {                                       //konstruktor
    dim(width, height);
}

MyImage::MyImage() {                                                            //přetížený konstruktor (bez parametrů)
    dim(1, 1);
}

MyImage::~MyImage() {                                                           //destruktor
    delete[] n;
}

void MyImage::dim(int width, int height) {                                      //nastavení velikosti snímku
    w = width;
    h = height;
    if (n != NULL) free(n);
    n = new uint32_t[w * h];
    if (d != NULL) free(d);
    d = new bool[w * h];
    for (int i = 0; i < (width * height); ++i)
        n[i] = 0xff000000;
    for (int i = 0; i < (width * height); ++i)
        d[i] = false;                                                           //příznak, zda byla barva zvenčí nastavena
    count = 0;
}

void MyImage::set_pixel(int x, int y, uint32_t c) {                             //nastavení barvy bodu
    mutex.lock();
    n[x + y * w] = c;
    count++;
    mutex.unlock();
}

void MyImage::set_done(int x, int y) {                                          //nastavení příznaku vypočteného bodu
    mutex.lock();
    d[x + y * w] = true;
    mutex.unlock();
}

void MyImage::x(f_vec x) {                                                      //zápis polohy pozorovatele
    loc = x;
}

void MyImage::v(f_vec v) {                                                      //zápis rychlosti pozorovatele
    speed = v;
}

uint32_t MyImage::read(int x, int y) const {                                    //vrácení barvy bodu
    return n[x + y * w];
}

bool MyImage::done(int x, int y) const {                                        //vrácení příznaku proběhlého výpočtu pro konkrétní bod
    return d[x + y * w];
}

int MyImage::done() const {                                                     //vrácení počtu vypočtených bodů
    QMutexLocker locker(&mutex);
    return count;
}

int MyImage::pixels() const {                                                   //vrácení počtu všech bodů obrázku
    return w * h;
}

int MyImage::width() const {                                                    //vrácení šířky obrázku
    return w;
}

int MyImage::height() const {                                                   //vrácení výšky obrázku
    return h;
}

f_vec MyImage::x() const {                                                      //vrácení polohy pozorovatele
    return loc;
}

f_vec MyImage::v() const {                                                      //vrácení rychlosti pozorovatele
    return speed;
}
