#include "operators.h"                                                          //přetížení operátorů pro čtyřvektory

f_vec operator+(const f_vec &a, const f_vec &b)                                 //sčítání čtyřvektorů
{
    return {a.x[0] + b.x[0], a.x[1] + b.x[1], a.x[2] + b.x[2], a.x[3] + b.x[3]};
}

f_vec operator-(const f_vec &a)                                                 //opačný čtyřvektor
{
    return {-a.x[0],-a.x[1],-a.x[2],-a.x[3]};
}

f_vec operator*(const f_vec &a, const real &b)                                  //násobení čtyřvektoru skalárem
{
    return {a.x[0] * b, a.x[1] * b, a.x[2] * b, a.x[3] * b};
}

real operator*(const f_vec &a, const f_vec &b)                                  //skalární součin (třívetorů)
{
    return (a.x[1] * b.x[1] + a.x[2] * b.x[2] + a.x[3] * b.x[3]);
}

f_vec operator/(const f_vec &a, const real &b)                                  //dělení čtyřvektoru skalárem
{
    return {a.x[0] / b, a.x[1] / b, a.x[2] / b, a.x[3] / b};
}
