#ifndef FORMULAS_H
#define FORMULAS_H

#include "struktury.h"                                                          //komplexnější proměnné a objekty

void kontr_g(QString g[4][4]);                                                  //výpočet kontravariantní metriky a překlad obou do kódu pro virtuální procesor
void VnH();                                                                     //výpočet horizontů
real VneH();                                                                    //výběr vnějšího horizontu událostí
real VniH();                                                                    //výběr vnitřního horizontu cauchyho
tensor_3 Christoffel(f_vec &x);                                                 //výpočet konexe
f_vec dudλ(f_vec u, tensor_3 &christoffel);                                     //derivace rychlosti podle afinního parametru z rovnice geodetiky
f_vec t_tet(f_vec u, f_vec x);                                                  //převod z sférických souřadnic metriky do statické tetrády
void tetrada(real (&e)[4][4], f_vec x);                                         //výpočet tetrády
f_vec transform(f_vec u, real (&e)[4][4]);                                      //transformace vektoru maticí
f_vec f_tet(f_vec u, f_vec x);                                                  //převod z statické tetrády do sférických souřadnic metriky
f_vec f_tet(f_vec v, f_vec u, f_vec x);                                         //převod z tetrády pozorovatele do sférických souřadnic metriky
f_vec aberace(real, real, f_vec v, f_vec x);                                    //relativistický součet rychlosti fotonu a pozorovatele na souřadnicích pozorovatele
real rshft(f_vec u_e, f_vec v_e, f_vec x_e, f_vec u_o, f_vec v_o, f_vec x_o);   //dopplerův rudý posuv
real beamg(f_vec u_e, f_vec v_e, f_vec x_e, f_vec u_o, f_vec v_o, f_vec x_o);   //relativistický beaming
f_vec four_vt(real vk);                                                         //převod obvodové rychlosti na čtyřvektor

#endif // FORMULAS_H
